//
//  Controller.m
//  Greeting
//
//  Created by Fumihiro Tezuka on 10/08/16.
//  Copyright 2010 viva Cocoa. All rights reserved.
//

#import "Controller.h"

@implementation Controller

- (id)init{
	[super init];
	model = [[Model alloc] init];
	voiceArray = [NSSpeechSynthesizer availableVoices];
	return self;
}

- (IBAction)inputString:(id)sender
{
	[model setGreeting:[sender stringValue]];
	NSString *greetingString = [model greeting];
	NSSpeechSynthesizer *synthesizer;
	NSDictionary *voiceDictionary;
	[voiceBy setHidden:NO];
	[voiceNameField setHidden:NO];
	for (NSString *voiceIdentifier in voiceArray) {
		synthesizer = [[NSSpeechSynthesizer alloc] initWithVoice:voiceIdentifier];
		
		/* 合成音声の名前を取得 */
		voiceDictionary = [NSSpeechSynthesizer attributesForVoice:voiceIdentifier];
		NSString *name = [voiceDictionary objectForKey:NSVoiceName];
		
		[synthesizer startSpeakingString:greetingString];
		[outputString setStringValue:greetingString];
		
		/* 合成音声の名前を voiceNameField に表示 */
		[voiceNameField setStringValue:name];
		
		/* テキスト・ビューとスピーチシンセサイザーでユーザーに現在の状態を伝えるための時間を確保 */
		[[NSRunLoop currentRunLoop] runUntilDate:[NSDate dateWithTimeIntervalSinceNow:2.5]];
	}
}

@end
